local EquipmentGantry = {}
EquipmentGantry.name = "equipment-gantry"
EquipmentGantry.container_horizontal_suffix = "-horizontal"
EquipmentGantry.containers = {
  ["grid"] = { name = "equipment-gantry-container-grid", position = {x=-0.5,y=0.5}, direction = 0 },
  ["output"] = { name = "equipment-gantry-container-output", position = {x=0.5,y=0.5}, direction = 0 },
  ["equipment"] = { name = "equipment-gantry-container-equipment", position = {x=0,y=-1}, direction = 2 },
}
EquipmentGantry.name_remover = "equipment-gantry-remover"
EquipmentGantry.containers_remover = {
  ["grid"] = { name = "equipment-gantry-remover-container-grid", position = {x=-0.5,y=0.5}, direction = 0 },
  ["output"] = { name = "equipment-gantry-remover-container-output", position = {x=0.5,y=0.5}, direction = 0 },
  ["equipment"] = { name = "equipment-gantry-remover-container-equipment", position = {x=0,y=-1}, direction = 2 },
}

function EquipmentGantry.on_entity_created(event)
  local entity
  if event.entity and event.entity.valid then
    entity = event.entity
  end
  if event.created_entity and event.created_entity.valid then
    entity = event.created_entity
  end

  if not entity then return end
  if entity.name == EquipmentGantry.name or entity.name == EquipmentGantry.name_remover then
    global.equipment_gantries = global.equipment_gantries or {}
    local gantry = {
      is_remover = entity.name == EquipmentGantry.name_remover,
      unit_number = entity.unit_number,
      force_name = entity.force.name,
      main = entity,
      containers = {}
    }
    gantry.main.active = false
    --entity.fluidbox[1] = {name = "lubricant", amount = 100}
    entity.rotatable = false
    global.equipment_gantries[entity.unit_number] = gantry
    for slot, container_def in pairs(gantry.is_remover and EquipmentGantry.containers_remover or EquipmentGantry.containers) do
      local h = (entity.direction + container_def.direction) % 4
      gantry.containers[slot] = entity.surface.create_entity{
        force = entity.force,
        name = container_def.name .. (h == 2 and EquipmentGantry.container_horizontal_suffix or ""),
        position = Util.vectors_add(entity.position, Util.rotate_vector(entity.orientation, container_def.position)),
      }
      gantry.containers[slot].destructible = false
    end
  end

end
Event.addListener(defines.events.on_built_entity, EquipmentGantry.on_entity_created)
Event.addListener(defines.events.on_robot_built_entity, EquipmentGantry.on_entity_created)
Event.addListener(defines.events.script_raised_built, EquipmentGantry.on_entity_created)
Event.addListener(defines.events.script_raised_revive, EquipmentGantry.on_entity_created)

function EquipmentGantry.destroy_sub(gantry, player_index)
  for _, container in pairs(gantry.containers) do
    local character
    local inv_character
    if player_index and game.players[player_index] and game.players[player_index].connected and game.players[player_index].character then
      character = game.players[player_index].character
      inv_character = character.get_inventory(defines.inventory.character_main)
    end
    local inv_chest = container.get_inventory(defines.inventory.chest)
    for i = 1, #inv_chest do
      if inv_chest[i] and inv_chest[i].valid_for_read then
        if inv_character and inv_character.can_insert(inv_chest[i]) then
          local name =  inv_chest[i].name
          local count = inv_chest[i].count
          local inserted = inv_character.insert(inv_chest[i])
          if inserted < count then
            character.surface.spill_item_stack(character.position, {name=name,count=count-inserted})
          end
        else
          container.surface.spill_item_stack(container.position, inv_chest[i])
        end
      end
    end
    container.destroy()
  end
  global.equipment_gantries[gantry.unit_number] = nil
end

function EquipmentGantry.on_entity_removed(event)
  local entity = event.entity
  if entity and entity.valid and entity.name == EquipmentGantry.name then
    if global.equipment_gantries and global.equipment_gantries[entity.unit_number] then
      EquipmentGantry.destroy_sub(global.equipment_gantries[entity.unit_number], event.player_index)
    end
  end
end
Event.addListener(defines.events.on_entity_died, EquipmentGantry.on_entity_removed)
Event.addListener(defines.events.on_robot_mined_entity, EquipmentGantry.on_entity_removed)
Event.addListener(defines.events.on_player_mined_entity, EquipmentGantry.on_entity_removed)
Event.addListener(defines.events.script_raised_destroy, EquipmentGantry.on_entity_removed)

function EquipmentGantry.on_nth_tick_60()
  if global.equipment_gantries then
    for unit_number, gantry in pairs(global.equipment_gantries) do
      if not gantry.main.valid then
        EquipmentGantry.destroy_sub(gantry)
      else
        local active = false
        if not gantry.is_remover then
          local output_inv = gantry.containers.output.get_inventory(defines.inventory.chest)
          if output_inv.is_empty() then
            local grid_inv = gantry.containers.grid.get_inventory(defines.inventory.chest)
            if not grid_inv.is_empty() then
              local grid_stack = grid_inv[1]
              local is_in_output = false
              if grid_stack.valid_for_read and grid_stack.type == "item-with-entity-data" then
                if not grid_stack.grid then
                  if grid_stack.count > 1 then
                    local stack_name = grid_stack.name
                    grid_inv.remove({name=stack_name, count = 1})
                    output_inv.insert({name=stack_name, count = 1})
                    grid_stack = output_inv[1]
                    is_in_output = true
                  end
                end
                grid_stack.create_grid()
              end
              --TODO: Handle stack size > 1
              if grid_stack.valid_for_read and grid_stack.grid then
                local equipment_inv = gantry.containers.equipment.get_inventory(defines.inventory.chest)
                if not equipment_inv.is_empty() then
                  local equipment_stack = equipment_inv[1]
                  if equipment_stack.valid_for_read then
                    local eq_result = equipment_stack.prototype.place_as_equipment_result
                    if eq_result then
                      local inserted = grid_stack.grid.put{ name = equipment_stack.prototype.place_as_equipment_result.name }
                      if inserted then
                        equipment_inv.remove({name = equipment_stack.name, count = 1})
                      end
                      if not is_in_output then
                        output_inv[1].swap_stack(grid_stack)
                      end
                      active = true
                    else
                      for _, player in pairs(game.forces[gantry.force_name].connected_players) do
                        if settings.get_player_settings(player)["print-equipment-gantry-warnings"].value then
                          player.print({"equipment-gantry.warning-invalid-ingredient", "[gps="..math.floor(gantry.main.position.x)..","..math.floor(gantry.main.position.y)..","..gantry.main.surface.name.."]"})
                        end
                      end
                    end
                  end
                end
              else
                --game.print("not valid or no grid " .. grid_stack.name)
                if grid_stack.grid then
                  --game.print("has grid")
                end
                output_inv[1].swap_stack(grid_stack)
                active = true
              end
            end
          end
        else
          local output_inv = gantry.containers.output.get_inventory(defines.inventory.chest)
          if output_inv.is_empty() then
            if not gantry.buffered_items then
              local grid_inv = gantry.containers.grid.get_inventory(defines.inventory.chest)
              if not grid_inv.is_empty() then
                local grid_stack = grid_inv[1]
                if grid_stack.valid_for_read and grid_stack.grid then
                  gantry.buffered_items = grid_stack.grid.take_all() -- are these item prototype names or equipment prototype names?
                  grid_stack.grid.clear()
                  output_inv[1].swap_stack(grid_stack)
                  active = true
                end
              end
            end
          end
          if gantry.buffered_items then
            -- process the buffer
            local equipment_inv = gantry.containers.equipment.get_inventory(defines.inventory.chest)
            if equipment_inv.is_empty() then
              active = true
              for item_name, count in pairs(gantry.buffered_items) do
                local inserted = equipment_inv.insert({name = item_name, count = count})
                local remain = count - inserted
                if remain > 0 then
                  gantry.buffered_items[item_name] = gantry.buffered_items[item_name] - inserted
                else
                  gantry.buffered_items[item_name] = nil
                end
              end
              if table_size(gantry.buffered_items) == 0 then
                gantry.buffered_items = nil
              end
            end
          end
        end
        gantry.main.active = active
      end
    end
  end
end
Event.addListener("on_nth_tick_60", EquipmentGantry.on_nth_tick_60) -- 1 minute

return EquipmentGantry
