local data_util = require("data-util")
if mods["informatron"] then
  informatron_make_image("informatron_equipment-gantry", "__equipment-gantry__/graphics/informatron/equipment-gantry-01.png", 881, 463)
end
-- NOTE: If the main entity is an assembler then inserters won't interact with containers
local blank = {
  direction_count = 8,
  frame_count = 1,
  filename = "__equipment-gantry__/graphics/blank.png",
  width = 1,
  height = 1,
  priority = "low"
}
local blank4 = {
  north = blank,
  south = blank,
  east = blank,
  west = blank,
}
local conditional_ingredient = mods["aai-industry"] and "electric-motor" or "iron-gear-wheel"
--[[
-- used for fluid turret 4-way
local animation = {
  layers =
  {
    {
      filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry.png",
      width = 192/2,
      height = 256/2,
      frame_count = 1,
      line_length = 4,
      direction_count = 4,
      shift = util.by_pixel(1, -1),
      hr_version =
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry.png",
        width = 192,
        height = 256,
        frame_count = 1,
        line_length = 4,
        direction_count = 4,
        shift = util.by_pixel(1, -1),
        scale = 0.5
      }
    },
    {
      filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-shadow.png",
      width = 256/2,
      height = 160/2,
      repeat_count = 1,
      frame_count = 1,
      line_length = 4,
      shift = util.by_pixel(16, 6),
      direction_count = 4,
      draw_as_shadow = true,
      hr_version =
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-shadow.png",
        width = 256,
        height = 160,
        repeat_count = 1,
        frame_count = 1,
        line_length = 4,
        direction_count = 4,
        shift = util.by_pixel(16, 6),
        draw_as_shadow = true,
        scale = 0.5
      }
    }
  }
}
local animation_remover = {
  layers =
  {
    {
      filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-remover.png",
      width = 192/2,
      height = 256/2,
      frame_count = 1,
      line_length = 4,
      direction_count = 4,
      shift = util.by_pixel(1, -1),
      hr_version =
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-remover.png",
        width = 192,
        height = 256,
        frame_count = 1,
        line_length = 4,
        direction_count = 4,
        shift = util.by_pixel(1, -1),
        scale = 0.5
      }
    },
    {
      filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-shadow.png",
      width = 256/2,
      height = 160/2,
      repeat_count = 1,
      frame_count = 1,
      line_length = 4,
      shift = util.by_pixel(16, 6),
      direction_count = 4,
      draw_as_shadow = true,
      hr_version =
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-shadow.png",
        width = 256,
        height = 160,
        repeat_count = 1,
        frame_count = 1,
        line_length = 4,
        direction_count = 4,
        shift = util.by_pixel(16, 6),
        draw_as_shadow = true,
        scale = 0.5
      }
    }
  }
}
]]
local animation = {
  north = {
    layers = {
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry.png",
        width = 192/2,
        height = 256/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(1, -1),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry.png",
          width = 192,
          height = 256,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(1, -1),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-h.png",
        width = 752/8/2,
        height = 232/4/2,
        frame_count = 8*4,
        line_length = 8,
        shift = util.by_pixel(-1, -48),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-h.png",
          width = 752/8,
          height = 232/4,
          frame_count = 8*4,
          line_length = 8,
          shift = util.by_pixel(-1, -48),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-beam-north.png",
        width = 1536/16/2,
        height = 94/2,
        frame_count = 16,
        run_mode = "forward-then-backward",
        shift = util.by_pixel(1, -14),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-beam-north.png",
          width = 1536/16,
          height = 94,
          frame_count = 16,
          run_mode = "forward-then-backward",
          shift = util.by_pixel(1, -14),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-shadow.png",
        width = 256/2,
        height = 160/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(16, 6),
        draw_as_shadow = true,
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-shadow.png",
          width = 256,
          height = 160,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(16, 6),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
    }
  },
  east = {
    layers = {
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry.png",
        x = 192/2,
        width = 192/2,
        height = 256/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(1, -1),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry.png",
          x = 192,
          width = 192,
          height = 256,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(1, -1),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-v.png",
        width = 368/8/2,
        height = 288/4/2,
        frame_count = 8*4,
        line_length = 8,
        shift = util.by_pixel(24, -18),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-v.png",
          width = 368/8,
          height = 288/4,
          frame_count = 8*4,
          line_length = 8,
          shift = util.by_pixel(24, -18),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-beam-east.png",
        width = 1440/16/2,
        height = 78/2,
        frame_count = 16,
        run_mode = "forward-then-backward",
        shift = util.by_pixel(-16, -18),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-beam-east.png",
          width = 1440/16,
          height = 78,
          frame_count = 16,
          run_mode = "forward-then-backward",
          shift = util.by_pixel(-16, -18),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-shadow.png",
        x = 256/2,
        width = 256/2,
        height = 160/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(16, 6),
        draw_as_shadow = true,
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-shadow.png",
          x = 256,
          width = 256,
          height = 160,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(16, 6),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
    }
  },
  south = {
    layers = {
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry.png",
        x = 192,
        width = 192/2,
        height = 256/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(1, -1),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry.png",
          x = 192*2,
          width = 192,
          height = 256,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(1, -1),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-h.png",
        width = 752/8/2,
        height = 232/4/2,
        frame_count = 8*4,
        line_length = 8,
        shift = util.by_pixel(0, -0),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-h.png",
          width = 752/8,
          height = 232/4,
          frame_count = 8*4,
          line_length = 8,
          shift = util.by_pixel(0, -0),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-beam-south.png",
        width = 1536/16/2,
        height = 96/2,
        frame_count = 16,
        run_mode = "forward-then-backward",
        shift = util.by_pixel(1, -36),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-beam-south.png",
          width = 1536/16,
          height = 96,
          frame_count = 16,
          run_mode = "forward-then-backward",
          shift = util.by_pixel(1, -36),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-shadow.png",
        x = 256,
        width = 256/2,
        height = 160/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(16, 6),
        draw_as_shadow = true,
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-shadow.png",
          x = 256*2,
          width = 256,
          height = 160,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(16, 6),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
    }
  },
  west = {
    layers = {
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry.png",
        x = 192/2*3,
        width = 192/2,
        height = 256/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(1, -1),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry.png",
          x = 192*3,
          width = 192,
          height = 256,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(1, -1),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-v.png",
        width = 368/8/2,
        height = 288/4/2,
        frame_count = 8*4,
        line_length = 8,
        shift = util.by_pixel(-24, -18),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-v.png",
          width = 368/8,
          height = 288/4,
          frame_count = 8*4,
          line_length = 8,
          shift = util.by_pixel(-24, -18),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-beam-west.png",
        width = 1440/16/2,
        height = 72/2,
        frame_count = 16,
        run_mode = "forward-then-backward",
        shift = util.by_pixel(16, -18),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-beam-west.png",
          width = 1440/16,
          height = 72,
          frame_count = 16,
          run_mode = "forward-then-backward",
          shift = util.by_pixel(16, -18),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-shadow.png",
        x = 256/2*3,
        width = 256/2,
        height = 160/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(16, 6),
        draw_as_shadow = true,
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-shadow.png",
          x = 256*3,
          width = 256,
          height = 160,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(16, 6),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
    }
  },
}
local animation_remover = {
  north = {
    layers = {
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-remover.png",
        width = 192/2,
        height = 256/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(1, -1),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-remover.png",
          width = 192,
          height = 256,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(1, -1),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-h.png",
        width = 752/8/2,
        height = 232/4/2,
        frame_count = 8*4,
        line_length = 8,
        shift = util.by_pixel(-1, -48),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-h.png",
          width = 752/8,
          height = 232/4,
          frame_count = 8*4,
          line_length = 8,
          shift = util.by_pixel(-1, -48),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-remover-animation-beam-north.png",
        width = 1536/16/2,
        height = 94/2,
        frame_count = 16,
        run_mode = "forward-then-backward",
        shift = util.by_pixel(1, -14),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-remover-animation-beam-north.png",
          width = 1536/16,
          height = 94,
          frame_count = 16,
          run_mode = "forward-then-backward",
          shift = util.by_pixel(1, -14),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-shadow.png",
        width = 256/2,
        height = 160/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(16, 6),
        draw_as_shadow = true,
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-shadow.png",
          width = 256,
          height = 160,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(16, 6),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
    }
  },
  east = {
    layers = {
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-remover.png",
        x = 192/2,
        width = 192/2,
        height = 256/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(1, -1),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-remover.png",
          x = 192,
          width = 192,
          height = 256,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(1, -1),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-v.png",
        width = 368/8/2,
        height = 288/4/2,
        frame_count = 8*4,
        line_length = 8,
        shift = util.by_pixel(24, -18),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-v.png",
          width = 368/8,
          height = 288/4,
          frame_count = 8*4,
          line_length = 8,
          shift = util.by_pixel(24, -18),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-remover-animation-beam-east.png",
        width = 1440/16/2,
        height = 78/2,
        frame_count = 16,
        run_mode = "forward-then-backward",
        shift = util.by_pixel(-16, -18),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-remover-animation-beam-east.png",
          width = 1440/16,
          height = 78,
          frame_count = 16,
          run_mode = "forward-then-backward",
          shift = util.by_pixel(-16, -18),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-shadow.png",
        x = 256/2,
        width = 256/2,
        height = 160/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(16, 6),
        draw_as_shadow = true,
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-shadow.png",
          x = 256,
          width = 256,
          height = 160,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(16, 6),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
    }
  },
  south = {
    layers = {
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-remover.png",
        x = 192,
        width = 192/2,
        height = 256/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(1, -1),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-remover.png",
          x = 192*2,
          width = 192,
          height = 256,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(1, -1),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-h.png",
        width = 752/8/2,
        height = 232/4/2,
        frame_count = 8*4,
        line_length = 8,
        shift = util.by_pixel(0, -0),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-h.png",
          width = 752/8,
          height = 232/4,
          frame_count = 8*4,
          line_length = 8,
          shift = util.by_pixel(0, -0),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-remover-animation-beam-south.png",
        width = 1536/16/2,
        height = 96/2,
        frame_count = 16,
        run_mode = "forward-then-backward",
        shift = util.by_pixel(1, -36),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-remover-animation-beam-south.png",
          width = 1536/16,
          height = 96,
          frame_count = 16,
          run_mode = "forward-then-backward",
          shift = util.by_pixel(1, -36),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-shadow.png",
        x = 256,
        width = 256/2,
        height = 160/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(16, 6),
        draw_as_shadow = true,
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-shadow.png",
          x = 256*2,
          width = 256,
          height = 160,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(16, 6),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
    }
  },
  west = {
    layers = {
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-remover.png",
        x = 192/2*3,
        width = 192/2,
        height = 256/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(1, -1),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-remover.png",
          x = 192*3,
          width = 192,
          height = 256,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(1, -1),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-animation-v.png",
        width = 368/8/2,
        height = 288/4/2,
        frame_count = 8*4,
        line_length = 8,
        shift = util.by_pixel(-24, -18),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-animation-v.png",
          width = 368/8,
          height = 288/4,
          frame_count = 8*4,
          line_length = 8,
          shift = util.by_pixel(-24, -18),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-remover-animation-beam-west.png",
        width = 1440/16/2,
        height = 72/2,
        frame_count = 16,
        run_mode = "forward-then-backward",
        shift = util.by_pixel(16, -18),
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-remover-animation-beam-west.png",
          width = 1440/16,
          height = 72,
          frame_count = 16,
          run_mode = "forward-then-backward",
          shift = util.by_pixel(16, -18),
          scale = 0.5
        }
      },
      {
        filename = "__equipment-gantry__/graphics/entity/equipment-gantry/equipment-gantry-shadow.png",
        x = 256/2*3,
        width = 256/2,
        height = 160/2,
        frame_count = 1,
        repeat_count = 32,
        shift = util.by_pixel(16, 6),
        draw_as_shadow = true,
        hr_version =
        {
          filename = "__equipment-gantry__/graphics/entity/equipment-gantry/hr-equipment-gantry-shadow.png",
          x = 256*3,
          width = 256,
          height = 160,
          frame_count = 1,
          repeat_count = 32,
          shift = util.by_pixel(16, 6),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
    }
  },
}
data:extend({
  {
    type = "recipe-category",
    name = "equipment-change"
  },
  {
    type = "recipe",
    name = "equipment-gantry-insert",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry.png",
    icon_size = 64,
    category = "equipment-change",
    subgroup = "equipment",
    enabled = false,
    energy_required = 1,
    ingredients = {},
    results= {},
  },
  {
    type = "recipe",
    name = "equipment-gantry-remove",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry-remover.png",
    icon_size = 64,
    category = "equipment-change",
    subgroup = "equipment",
    enabled = false,
    energy_required = 1,
    ingredients = {},
    results= {},
  },
  {
    type = "item",
    name = "equipment-gantry",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry.png",
    icon_size = 64,
    subgroup = "production-machine",
    order = "q-a",
    stack_size = 50,
    place_result = "equipment-gantry",
  },
  {
    type = "item",
    name = "equipment-gantry-remover",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry-remover.png",
    icon_size = 64,
    subgroup = "production-machine",
    order = "q-b",
    stack_size = 50,
    place_result = "equipment-gantry-remover",
  },
  {
    type = "recipe",
    name = "equipment-gantry",
    category = "crafting",
    normal = {
      enabled = false,
      energy_required = 4,
      ingredients = {
        {type="item", name="iron-plate", amount=20},
        {type="item", name="iron-chest", amount=3},
        {type="item", name=conditional_ingredient, amount=8},
      },
      results= { {type="item", name="equipment-gantry", amount=1} },
    },
    expensive = {
      enabled = false,
      energy_required = 4,
      ingredients = {
        {type="item", name="iron-plate", amount=20},
        {type="item", name="iron-chest", amount=4},
        {type="item", name=conditional_ingredient, amount=8},
      },
      results= { {type="item", name="equipment-gantry", amount=1} },
    }
  },
  {
    type = "recipe",
    name = "equipment-gantry-remover",
    category = "crafting",
    normal = {
      enabled = false,
      energy_required = 4,
      ingredients = {
        {type="item", name="iron-plate", amount=20},
        {type="item", name="iron-chest", amount=3},
        {type="item", name=conditional_ingredient, amount=8},
      },
      results= { {type="item", name="equipment-gantry-remover", amount=1} },
    },
    expensive = {
      enabled = false,
      energy_required = 4,
      ingredients = {
        {type="item", name="iron-plate", amount=20},
        {type="item", name="iron-chest", amount=4},
        {type="item", name=conditional_ingredient, amount=8},
      },
      results= { {type="item", name="equipment-gantry-remover", amount=1} },
    }
  },
  {
    type = "technology",
    name = "equipment-gantry",
    icon = "__equipment-gantry__/graphics/technology/equipment-gantry.png",
    icon_size = 256,
    order = "b",
    prerequisites = {
      "modular-armor",
    },
    unit = {
        count = 200,
        ingredients = {
            {"automation-science-pack", 1},
            {"logistic-science-pack", 1},
        },
        time = 30
    },
    effects = {
      { type = "unlock-recipe", recipe = "equipment-gantry" },
      { type = "unlock-recipe", recipe = "equipment-gantry-remover" },
    },
  },
  {
    type = "container",
    name = "equipment-gantry-container-grid",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry.png",
    icon_size = 64,
    flags = {"placeable-neutral", "player-creation", "not-blueprintable", "not-deconstructable"},
    max_health = 250,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.43 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.43 },
    se_allow_in_space = true,
    collision_mask = {},
    collision_box = {{-0.3, -0.8},{0.3, 0.8}},
    selection_box = {{-0.3, -0.8},{0.3, 0.8}},
    inventory_size = 1,
    picture = blank,
    selection_priority = 52,
  },
  {
    type = "container",
    name = "equipment-gantry-container-equipment",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry.png",
    icon_size = 64,
    flags = {"placeable-neutral", "player-creation", "not-blueprintable", "not-deconstructable"},
    max_health = 250,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.43 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.43 },
    se_allow_in_space = true,
    collision_mask = {},
    collision_box = {{-0.3, -0.8},{0.3, 0.8}},
    selection_box = {{-0.3, -0.8},{0.3, 0.8}},
    inventory_size = 1,
    picture = blank,
    selection_priority = 52,
  },
  {
    type = "container",
    name = "equipment-gantry-container-output",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry.png",
    icon_size = 64,
    flags = {"placeable-neutral", "player-creation", "not-blueprintable", "not-deconstructable"},
    max_health = 250,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.43 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.43 },
    se_allow_in_space = true,
    collision_mask = {},
    collision_box = {{-0.3, -0.8},{0.3, 0.8}},
    selection_box = {{-0.3, -0.8},{0.3, 0.8}},
    inventory_size = 1,
    picture = blank,
    selection_priority = 52,
  },
  {
    type = "container",
    name = "equipment-gantry-remover-container-grid",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry-remover.png",
    icon_size = 64,
    flags = {"placeable-neutral", "player-creation", "not-blueprintable", "not-deconstructable"},
    max_health = 250,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.43 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.43 },
    se_allow_in_space = true,
    collision_mask = {},
    collision_box = {{-0.3, -0.8},{0.3, 0.8}},
    selection_box = {{-0.3, -0.8},{0.3, 0.8}},
    inventory_size = 1,
    picture = blank,
    selection_priority = 52,
  },
  {
    type = "container",
    name = "equipment-gantry-remover-container-equipment",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry-remover.png",
    icon_size = 64,
    flags = {"placeable-neutral", "player-creation", "not-blueprintable", "not-deconstructable"},
    max_health = 250,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.43 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.43 },
    se_allow_in_space = true,
    collision_mask = {},
    collision_box = {{-0.3, -0.8},{0.3, 0.8}},
    selection_box = {{-0.3, -0.8},{0.3, 0.8}},
    inventory_size = 1,
    picture = blank,
    selection_priority = 52,
  },
  {
    type = "container",
    name = "equipment-gantry-remover-container-output",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry-remover.png",
    icon_size = 64,
    flags = {"placeable-neutral", "player-creation", "not-blueprintable", "not-deconstructable"},
    max_health = 250,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.43 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.43 },
    se_allow_in_space = true,
    collision_mask = {},
    collision_box = {{-0.3, -0.8},{0.3, 0.8}},
    selection_box = {{-0.3, -0.8},{0.3, 0.8}},
    inventory_size = 1,
    picture = blank,
    selection_priority = 52,
  },
  {
    type = "assembling-machine",
    name = "equipment-gantry",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry.png",
    icon_size = 64,
    flags = {"placeable-neutral", "placeable-player", "player-creation", "no-automated-item-removal", "no-automated-item-insertion"},
    minable = {mining_time = 0.2, result = "equipment-gantry"},
    max_health = 250,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    alert_icon_shift = util.by_pixel(0, -12),
    se_allow_in_space = true,
    collision_box = {{-0.8, -1.3}, {0.8, 1.3}},
    selection_box = {{-1, -1.5}, {1, 1.5}},
    resistances ={{ type = "impact",percent = 50  }},
    open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
    close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source = {
      buffer_capacity = "1kJ",
      drain = "100kW",
      input_flow_limit = "100MW",
      type = "electric",
      usage_priority = "primary-input"
    },
    working_sound = {
      apparent_volume = 1.5,
      idle_sound = {
        filename = "__base__/sound/idle1.ogg",
        volume = 0.6
      },
      sound = {
        {
          filename = "__base__/sound/assembling-machine-t1-1.ogg",
          volume = 0.5
        },
        {
          filename = "__base__/sound/assembling-machine-t1-2.ogg",
          volume = 0.5
        }
      }
    },
    animation  = animation,
    crafting_categories = {"equipment-change"},
    crafting_speed = 1,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions_per_minute = 4,
    },
    fixed_recipe = "equipment-gantry-insert",
    energy_usage = "250kW",
    ingredient_count = 0,
    allowed_effects = {},
    working_visualisations =
    {
      {
        effect = "uranium-glow", -- changes alpha based on energy source light intensity
        light = {intensity = 0.5, size = 8, shift = {0.0, 0.0}, color = {r = 1, g = 0.9, b = 0.5}}
      },
    },
  },
  {
    type = "assembling-machine",
    name = "equipment-gantry-remover",
    icon = "__equipment-gantry__/graphics/icons/equipment-gantry-remover.png",
    icon_size = 64,
    flags = {"placeable-neutral", "placeable-player", "player-creation", "no-automated-item-removal", "no-automated-item-insertion"},
    minable = {mining_time = 0.2, result = "equipment-gantry-remover"},
    max_health = 250,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    alert_icon_shift = util.by_pixel(0, -12),
    se_allow_in_space = true,
    collision_box = {{-0.8, -1.3}, {0.8, 1.3}},
    selection_box = {{-1, -1.5}, {1, 1.5}},
    resistances ={{ type = "impact",percent = 50  }},
    open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
    close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source = {
      buffer_capacity = "1kJ",
      drain = "100kW",
      input_flow_limit = "100MW",
      type = "electric",
      usage_priority = "primary-input"
    },
    working_sound = {
      apparent_volume = 1.5,
      idle_sound = {
        filename = "__base__/sound/idle1.ogg",
        volume = 0.6
      },
      sound = {
        {
          filename = "__base__/sound/assembling-machine-t1-1.ogg",
          volume = 0.5
        },
        {
          filename = "__base__/sound/assembling-machine-t1-2.ogg",
          volume = 0.5
        }
      }
    },
    animation = animation_remover,
    crafting_categories = {"equipment-change"},
    crafting_speed = 1,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions_per_minute = 4,
    },
    fixed_recipe = "equipment-gantry-remove",
    energy_usage = "250kW",
    ingredient_count = 0,
    allowed_effects = {}, -- not "productivity",
    working_visualisations =
    {
      {
        effect = "uranium-glow", -- changes alpha based on energy source light intensity
        light = {intensity = 0.5, size = 8, shift = {0.0, 0.0}, color = {r = 1, g = 0.9, b = 0.5}}
      },
    },
  },
})

for _, base_name in pairs({
  "equipment-gantry-container-grid",
  "equipment-gantry-container-equipment",
  "equipment-gantry-container-output",
  "equipment-gantry-remover-container-grid",
  "equipment-gantry-remover-container-equipment",
  "equipment-gantry-remover-container-output"}) do
  local h = table.deepcopy(data.raw.container[base_name])
  h.name = base_name.."-horizontal"
  h.localised_name = {"entity-name."..base_name}
  h.collision_box = {{-0.8, -0.3},{0.8, 0.3}}
  h.selection_box = {{-0.8, -0.3},{0.8, 0.3}}
  data:extend({h})
end
