local tint_colors = 
{
  green = {r=000/255, g=255/255, b=000/255, a=1},
  orange = {r=232/255, g=139/255, b=000/255, a=1},
  red = {r=244/255, g=008/255, b=000/255, a=1},
  blue = {r=000/255, g=067/255, b=237/255, a=1},
}

-------------------------------------------------------------------------------
-- RADIOACTIVE MATERIAL PROCESSING
-------------------------------------------------------------------------------
data:extend(
{
  --order a[uranium]-a[processing] reserved for uranium processing
  --order a[uranium]-b[enrichment] reserved for kovarkex enrichment process
  {
    type = "recipe",
    name = "angels-plutonium-synthesis",
    localised_name = {"recipe-name.angels-plutonium-synthesis"},
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-processing",
    energy_required = 120,--180
    ingredients =
    {
      {type = "item", name = "neptunium-240", amount = 8},
    },
    results = 
    {
      {type = "item", name = "plutonium-240", amount = 5},
    },
    main_product = "plutonium-240",
    always_show_products = true,
    show_amount_in_title = false,
    icons = 
    {
      { -- need to have something as bottom layer
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
      {
        icon = "__angelsindustries__/graphics/icons/neptunium-240.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 45/64,
        shift = {-7,-5}
      },
      {
        icon = "__angelsindustries__/graphics/icons/plutonium-239.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 2/3,
        shift = {5,7}
      },
      {
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
    },
    icon_size = 32,
    order = "b[AMOX]-a[processing]",
    crafting_machine_tint = 
    {
      primary = tint_colors.orange,
    },
  },
  {
    type = "recipe",
    name = "angels-americium-regeneration",
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-processing",
    energy_required = 210,--540
    ingredients =
    {
      {type = "item", name = "americium-241", amount = 5},
      {type = "item", name = "uranium-238", amount = 60},
      {type = "item", name = "plutonium-240", amount = 1}
    },
    results = 
    {
      --{type = "item", name = "uranium-235", amount = 1,probability=0.3},
      {type = "item", name = "plutonium-240", amount = 6,catalyst_amount=1},
      {type = "item", name = "uranium-238", amount = 15,catalyst_amount = 15},
      {type = "item", name = "solid-lead-oxide", amount = 5}, -- equals 5 lead plates
    },
    icons = 
    {
      { -- need to have something as bottom layer
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
      {
        icon = "__angelsindustries__/graphics/icons/americium-241.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 45/64,
        shift = {-7,-5}
      },
      {
        icon = "__angelsindustries__/graphics/icons/plutonium-239.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 2/3,
        shift = {5,7}
      },
      {
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
    },
    icon_size = 32,
    order = "b[AMOX]-b[recovery]",
    crafting_machine_tint = 
    {
      primary = tint_colors.orange,
    },
  },
  {
    type = "recipe",
    name = "angels-thorium-processing",
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-processing",
    energy_required = 20,
    ingredients =
    {
      {type = "item", name = "thorium-ore", amount = 5},
    },
    results = 
    {
      {type = "item", name = "thorium-232", amount = 4},
      {type = "item", name = "plutonium-240", amount = 1, probability=0.15}, --must be low enough to not be self-sustainable
    },
    icons = 
    {
      { -- need to have something as bottom layer
        icon = "__base__/graphics/icons/uranium-processing.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64,
        tint = {a=0.01},
      },
      {
        icon = "__angelssmelting__/graphics/icons/ore-thorium.png",
        icon_size = 64,
        icon_mipmaps = 1, --unsure
        scale = 32/64 * 40/64,
        shift = {0,-6}
      },
      {
        icon = "__angelsindustries__/graphics/icons/thorium-232.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 32/64,
        shift = {-8,8}
      },
      {
        icon = "__angelsindustries__/graphics/icons/plutonium-239.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 32/64,
        shift = {8,8}
      },
    },
    icon_size = 32,
    order = "c[thorium]-a[processing]",
    crafting_machine_tint = 
    {
      primary = tint_colors.red,
    },
  },
})

-------------------------------------------------------------------------------
-- NUCLEAR FUEL CELLS ---------------------------------------------------------
-------------------------------------------------------------------------------
data:extend(
{
  --URANIUM FUEL
  --advanced fuel cell
  {
    type = "recipe",
    name = "angels-uranium-fuel-cell",
    localised_name = {"recipe-name.angels-uranium-fuel-cell"},
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 700,--7000
    ingredients =
    {
      {type = "item", name = "uranium-234", amount = 1},
      {type = "item", name = "uranium-238", amount = 199},
      {type = "item", name = "iron-plate", amount = 100},
    },
    results = 
    {
      {type = "item", name = "angels-uranium-fuel-cell", amount = 100},
    },
    main_product = "angels-uranium-fuel-cell",
    always_show_products = true,
    show_amount_in_title = false,
    icon_size = 32,
    order = "a[uranium]-b",
    crafting_machine_tint = 
    {
      primary = tint_colors.green,
    },
  },
  --advanced reprocessing
  {
    type = "recipe",
    name = "angels-advanced-uranium-reprocessing",
    enabled = false,
    category = "advanced-chemistry",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 80,--120
    ingredients =
    {
      {type = "item", name = "used-up-uranium-fuel-cell", amount = 10},
      {type = "fluid", name = "liquid-hydrofluoric-acid", amount = 60},
    },
    results = 
    {
      {type = "item", name = "uranium-238", amount = 5},
      {type = "item", name = "slag", amount = 10},
      {type = "item", name = "neptunium-240", amount = 1,probability=0.4},
      {type = "fluid", name = "water-greenyellow-waste", amount = 60},
    },
    icons = 
    {
      { -- need to have something as bottom layer
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
      {
        icon = "__angelsindustries__/graphics/icons/used-up-uranium-fuel-cell.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 45/64,
        shift = {-7,-5}
      },
      {
        icon = "__angelsindustries__/graphics/icons/neptunium-240.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 2/3,
        shift = {5,7}
      },
      {
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
    },
    --icon_size = 32,
    order = "a[uranium]-d", -- "a[uranium]-c" reserved for vanilla reprocessing
    crafting_machine_tint = 
    {
      primary = tint_colors.green,
    },
  },
  --AMOX FUEL
  --fuel cell
  {
    type = "recipe",
    name = "angels-mixed-oxide-cell",
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 80,--1200
    ingredients =
    {
      {type = "item", name = "uranium-238", amount = 38},
      {type = "item", name = "plutonium-240", amount = 2},
      {type = "item", name = "angels-plate-lead", amount = 20},
    },
    results = 
    {
      {type = "item", name = "AMOX-cell", amount = 20},
    },
    main_product = "AMOX-cell",
    always_show_products = true,
    show_amount_in_title = false,
    icon_size = 32,
    order = "b[AMOX]-a",
    crafting_machine_tint = 
    {
      primary = tint_colors.orange,
    },
  },
  --basic reprocessing
  {
    type = "recipe",
    name = "angels-mixed-oxide-reprocessing",
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 110,--330
    ingredients =
    {
      {type = "item", name = "used-up-AMOX-cell", amount = 5}
    },
    results = 
    {
      {type = "item", name = "americium-241", amount = 1},
      {type = "item", name = "americium-241", amount = 1,probability=0.95},
      {type = "item", name = "curium-245", amount = 1,probability=0.05},
      {type = "item", name = "uranium-238", amount = 1},
      {type = "item", name = "slag", amount = 5},
    },
    icons = 
    {
      { -- need to have something as bottom layer
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
      {
        icon = "__angelsindustries__/graphics/icons/used-up-plutonium-fuel-cell.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 45/64,
        shift = {-7,-5}
      },
      {
        icon = "__angelsindustries__/graphics/icons/americium-241.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 2/3,
        shift = {5,7}
      },
      {
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
    },
    --icon_size = 32,
    order = "b[AMOX]-b",
    crafting_machine_tint = 
    {
      primary = tint_colors.orange,
    },
  },
  --advanced reprocessing
  {
    type = "recipe",
    name = "angels-advanced-mixed-oxide-reprocessing",
    enabled = false,
    category = "advanced-chemistry",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 260,
    ingredients =
    {
      {type = "item", name = "used-up-AMOX-cell", amount = 10},
      {type = "fluid", name = "liquid-hydrofluoric-acid", amount = 60},
    },
    results = 
    {
      {type = "item", name = "plutonium-240", amount = 4},
      {type = "item", name = "slag", amount = 10},
      {type = "item", name = "curium-245", amount = 2,probability=0.45},
      {type = "item", name = "uranium-235", amount = 1,probability=0.2},
      {type = "fluid", name = "water-greenyellow-waste", amount = 60},
    },
    icons=
    {
      { -- need to have something as bottom layer
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
      {
        icon = "__angelsindustries__/graphics/icons/used-up-plutonium-fuel-cell.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 45/64,
        shift = {-7,-5}
      },
      {
        icon = "__angelsindustries__/graphics/icons/plutonium-239.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 0.58,
        shift = {7.5,3}
      },
      {
        icon = "__angelsindustries__/graphics/icons/curium-245.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 0.58,
        shift = {2,9}
      },
      {
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
    },
    --icon_size = 32,
    order = "b[AMOX]-c",
    crafting_machine_tint = 
    {
      primary = tint_colors.orange,
    },
  },
  --THORIUM FUEL
  --basic fuel cell
  {
    type = "recipe",
    name = "angels-thorium-fuel-cell",
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 500,--1000
    ingredients =
    {
      {type = "item", name = "thorium-232", amount = 17},
      {type = "item", name = "curium-245", amount = 1},
      {type = "item", name = "plutonium-240", amount = 3},
      {type = "item", name = "angels-plate-zinc", amount = 10},
    },
    results = 
    {
      {type = "item", name = "angels-thorium-fuel-cell", amount = 10},
    },
    main_product = "angels-thorium-fuel-cell",
    always_show_products = true,
    show_amount_in_title = false,
    icon_size = 32,
    order = "c[thorium]-a",
    crafting_machine_tint = 
    {
      primary = tint_colors.red,
    },
  },
  --advanced fuel cell
  --[[{
    type = "recipe",
    name = "angels-thorium-fuel-cell-2",
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 900,
    ingredients =
    {
      {type = "item", name = "thorium-232", amount = 15},
      {type = "item", name = "americium-241", amount = 2},
      {type = "item", name = "plutonium-240", amount = 4},
      {type = "item", name = "angels-plate-zinc", amount = 10},
    },
    results = 
    {
      {type = "item", name = "angels-thorium-fuel-cell", amount = 10},
    },
    main_product = "angels-thorium-fuel-cell",
    always_show_products = true,
    show_amount_in_title = false,
    icon_size = 32,
    order = "c[thorium]-b",
    crafting_machine_tint = 
    {
      primary = tint_colors.red,
    },
  },]]
  --basic reprocessing
  {
    type = "recipe",
    name = "angels-thorium-fuel-cell-reprocessing",
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 450,
    ingredients =
    {
      {type = "item", name = "used-up-angels-thorium-fuel-cell", amount = 5},
    },
    results=
    {
      {type = "item", name = "slag", amount = 5},
      {type = "item", name = "neptunium-240", amount = 1},
      {type = "item", name = "thorium-232", amount = 2},
      {type = "item", name = "uranium-234", amount = 1,probability=0.05},
      {type = "item", name = "curium-245", amount = 1,probability=0.1},
    },
    icons = 
    {
      { -- need to have something as bottom layer
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
      {
        icon = "__angelsindustries__/graphics/icons/used-up-thorium-fuel-cell.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 45/64,
        shift = {-7,-5}
      },
      {
        icon = "__angelsindustries__/graphics/icons/neptunium-240.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 0.58,
        shift = {7.5,3}
      },
      {
        icon = "__angelsindustries__/graphics/icons/thorium-232.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 0.58,
        shift = {2,9}
      },
      {
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
    },
    --icon_size = 32,
    order = "c[thorium]-c",
    crafting_machine_tint = 
    {
      primary = tint_colors.red,
    },
  },
  -- advanced reprocessing
  {
    type = "recipe",
    name = "angels-advanced-thorium-fuel-cell-reprocessing",
    enabled = false,
    category = "advanced-chemistry",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 1000,
    ingredients =
    {
      {type = "item", name = "used-up-angels-thorium-fuel-cell", amount = 10},
      {type = "fluid", name = "liquid-hydrofluoric-acid", amount = 60},
    },
    results=
    {
      {type = "item", name = "slag", amount = 10},
      {type = "item", name = "neptunium-240", amount = 2},
      {type = "item", name = "uranium-234", amount = 2,probability=0.05},
      {type = "fluid", name = "water-greenyellow-waste", amount = 60},
      {type = "item", name = "angels-muon-fusion-catalyst", amount = 1, catalyst_amount = 1, probability=4/30},
    },
    icons = 
    {
      { -- need to have something as bottom layer
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
      {
        icon = "__angelsindustries__/graphics/icons/used-up-thorium-fuel-cell.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 45/64,
        shift = {-7,-5}
      },
      {
        icon = "__angelsindustries__/graphics/icons/neptunium-240.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 0.58,
        shift = {7.5,3}
      },
      {
        icon = "__angelsindustries__/graphics/icons/fusion-catalyst.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64 * 0.48,
        shift = {2,9}
      },
      {
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
    },
    --icon_size = 32,
    order = "c[thorium]-d",
    crafting_machine_tint = 
    {
      primary = tint_colors.red,
    },
  },
  --DEUTERIUM FUEL
  -- fuel cell
  {
    type = "recipe",
    name = "angels-deuterium-fuel-cell",
    enabled = false,
    category = "chemistry",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 150,--1500
    ingredients =
    {
      {type = "fluid", name = "gas-deuterium", amount = 600},
      {type = "item", name = "angels-plate-zinc", amount = 1},
      {type = "item", name = "angels-muon-fusion-catalyst", amount = 1},
    },
    results = 
    {
      {type = "item", name = "angels-deuterium-fuel-cell", amount = 1},
    },
    main_product = "angels-deuterium-fuel-cell",
    always_show_products = true,
    show_amount_in_title = false,
    icon_size = 32,
    order = "d[deuterium]-a",
    crafting_machine_tint = 
    {
      primary = tint_colors.blue,
    },
  },
  -- reprocessing
  {
    type = "recipe",
    name = "angels-deuterium-fuel-cell-reprocessing",
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 800, --6000
    ingredients =
    {
      {type = "item", name = "used-up-angels-deuterium-fuel-cell", amount = 5},
    },
    results=
    {
      {type = "item", name = "slag", amount = 5},
      {type = "item", name = "angels-muon-fusion-catalyst", amount = 4, catalyst_amount = 4}, -- make it lose 1%; 99% of 5 = 4.95 return
      {type = "item", name = "angels-muon-fusion-catalyst", amount = 1, catalyst_amount = 1, probability=0.95, show_details_in_recipe_tooltip=false},
    },
    icons = 
    {
      { -- need to have something as bottom layer
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
      {
        icon = "__angelsindustries__/graphics/icons/used-up-deuterium-fuel-cell.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 45/64,
        shift = {-7,-5}
      },
      {
        icon = "__angelsindustries__/graphics/icons/fusion-catalyst.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64 * 0.5,
        shift = {5,7}
      },
      {
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
    },
    --icon_size = 32,
    order = "d[deuterium]-b",
    crafting_machine_tint = 
    {
      primary = tint_colors.blue,
    },
  },
  -- advanced reprocessing
  {
    type = "recipe",
    name = "angels-advanced-deuterium-fuel-cell-reprocessing",
    enabled = false,
    category = "centrifuging",
    subgroup = "angels-power-nuclear-fuel-cell",
    energy_required = 800, --6000
    ingredients =
    {
      {type = "item", name = "used-up-angels-deuterium-fuel-cell", amount = 10},
      {type = "fluid", name = "liquid-hydrofluoric-acid", amount = 60},
    },
    results=
    {
      {type = "item", name = "slag", amount = 5},
      {type = "fluid", name = "water-greenyellow-waste", amount = 60},
      {type = "item", name = "angels-muon-fusion-catalyst", amount = 10, catalyst_amount = 10},
    },
    icons = 
    {
      { -- need to have something as bottom layer
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
      {
        icon = "__angelsindustries__/graphics/icons/used-up-deuterium-fuel-cell.png",
        icon_size = 64,
        icon_mipmaps = 4,
        scale = 32/64 * 45/64,
        shift = {-7,-5}
      },
      {
        icon = "__angelsindustries__/graphics/icons/fusion-catalyst.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64 * 0.58,
        shift = {7.5,3}
      },
      {
        icon = "__angelsindustries__/graphics/icons/fusion-catalyst.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64 * 0.48,
        shift = {2,9}
      },
      {
        icon = "__angelsindustries__/graphics/icons/reprocessing_arrow.png",
        icon_size = 64,
        icon_mipmaps = 1,
        scale = 32/64
      },
    },
    --icon_size = 32,
    order = "d[deuterium]-c",
    crafting_machine_tint = 
    {
      primary = tint_colors.blue,
    },
  },
})
-------------------------------------------------------------------------------
-- NUCLEAR ADDITIONS ----------------------------------------------------------
-------------------------------------------------------------------------------
data:extend(
  {
    {
      type = "recipe",
      name = "angels-nuclear-fuel",
      energy_required = 90,
      enabled = false,
      category = "centrifuging",
      ingredients ={
        {type = "item", name = "plutonium-240", amount = 1},
        {type = "item", name = "rocket-fuel", amount = 1}
      },
      --icon = "__base__/graphics/icons/nuclear-fuel.png",
      --icon_size = 64, icon_mipmaps = 4,
      results =
      {
        {type = "item", name = "angels-nuclear-fuel", amount = 1}
      }
    },
    { --do i want this?
      type = "recipe",
      name = "angels-nuclear-fuel-2",
      energy_required = 90,
      enabled = false,
      category = "centrifuging",
      ingredients ={
        {type = "item", name = "plutonium-240", amount = 2},
        {type = "item", name = "rocket-fuel", amount = 3},
        {type = "item", name = "thorium-232", amount = 1}
      },
      --icon = "__base__/graphics/icons/nuclear-fuel.png",
      --icon_size = 64, icon_mipmaps = 4,
      results =
      {
        {type = "item", name = "angels-nuclear-fuel-2", amount = 3}
      }
    },
    {
      type = "recipe",
      name = "angels-atomic-bomb",
      enabled = false,
      energy_required = 50,
      icons = angelsmods.functions.add_number_icon_layer(
        angelsmods.functions.get_object_icons("atomic-bomb"),
        2, angelsmods.industries.number_tint),
      ingredients =
      {
        {type = "item", name = "rocket-control-unit", amount = 10},
        {type = "item", name = "explosives", amount = 10},
        {type = "item", name = "rocket-booster", amount = 1},
        {type = "item", name = "plutonium-240", amount = 30}
      },
      results =
      {
        {type = "item", name = "atomic-bomb", amount = 1}
      },
      order="d[rocket-launcher]-d[atomic-bomb]-a"
    },
    {
      type = "recipe",
      name = "angels-atomic-bomb-2",
      category = "advanced-chemistry",
      enabled = false,
      energy_required = 50,
      icons = angelsmods.functions.add_number_icon_layer(
        angelsmods.functions.get_object_icons("atomic-bomb"),
        3, angelsmods.industries.number_tint),
      ingredients =
      {
        {type = "item", name = "rocket-control-unit", amount = 20},
        {type = "item", name = "explosives", amount = 20},
        {type = "item", name = "rocket-booster", amount = 1},
        {type = "fluid", name = "gas-deuterium", amount = 3600},
        {type = "item", name = "angels-muon-fusion-catalyst", amount = 1}
      },
      results =
      {
        {type = "item", name = "atomic-bomb", amount = 2}
      },
      order="d[rocket-launcher]-d[atomic-bomb]-b"
    },
  }
)

