if angelsmods.industries.tech then
  local OV = angelsmods.functions.OV
  --require("prototypes.overrides.industries-override-functions")

  -------------------------------------------------------------------------------
  -- NO CORES -------------------------------------------------------------------
  -------------------------------------------------------------------------------
  OV.remove_science_pack("rocket-silo", "datacore-war-1")
  OV.execute()

  -- catch most of the cores with the core builder
  core_builder()
  OV.execute()

  -------------------------------------------------------------------------------
  -- BASIC CORES ----------------------------------------------------------------
  -------------------------------------------------------------------------------
  -- BASE GAME
  core_replace("automation", "processing", "basic")
  core_replace("logistics", "logistic", "basic")
  core_replace("turrets", "war", "basic")
  core_replace("flammables", "war", "enhance")
  -- REFINING
  core_replace("water-treatment", "processing", "basic")
  -- SMELTING
  core_replace("angels-solder-smelting-basic", "processing", "basic")
  -- BIO PROCESSING
  core_replace("bio-processing-brown", "processing", "basic")
  core_replace("bio-paper-1", "processing", "basic")
  -- INDUSTRIES
  OV.set_science_pack("tech-red-circuit", "datacore-basic", 2)
  OV.set_science_pack("tech-green-circuit", "datacore-basic", 2)
  OV.set_science_pack("tech-orange-circuit", "datacore-basic", 2)
  OV.set_science_pack("tech-blue-circuit", "datacore-basic", 2)
  OV.set_science_pack("tech-yellow-circuit", "datacore-basic", 2)
  -- DECORATION ADDONS
  if mods["angelsaddons-nilaus"] --[[angelsmods.addons.decorations]] then
    --if angelsmods.addons.decorations then
    OV.set_science_pack("nilaus", "datacore-basic", 2)
  end
  if mods["angelsaddons-shred"] --[[angelsmods.addons.decorations]] then
    OV.set_science_pack("deco-shred", "datacore-basic", 2)
  end

  -------------------------------------------------------------------------------
  -- EXPLORATION CORES ----------------------------------------------------------
  -------------------------------------------------------------------------------
  -- BASE GAME
  OV.set_science_pack("landfill", "datacore-exploration-1", 2)
  OV.set_science_pack("automobilism", "datacore-exploration-1", 2)
  core_replace("space-science-pack", "processing", "exploration")
  core_replace("artillery-shell-range-1", "war", "exploration")
  -- BIO PROCESSING
  core_replace("bio-refugium-hatchery", "processing", "exploration")
  core_replace("bio-refugium-fish-1", "processing", "exploration")
  core_replace("bio-refugium-fish-2", "processing", "exploration")
  core_replace("bio-refugium-puffer-1", "processing", "exploration")
  core_replace("bio-refugium-puffer-2", "processing", "exploration")
  core_replace("bio-refugium-puffer-3", "processing", "exploration")
  core_replace("bio-refugium-puffer-4", "processing", "exploration")
  core_replace("bio-refugium-biter-1", "processing", "exploration")
  core_replace("bio-refugium-biter-2", "processing", "exploration")
  core_replace("bio-refugium-biter-3", "processing", "exploration")
  OV.set_science_pack("bio-temperate-farm", "datacore-processing-1", 2)
  OV.set_science_pack("bio-desert-farm", "datacore-processing-1", 2)
  OV.set_science_pack("bio-swamp-farm", "datacore-processing-1", 2)
  -- INDUSTRIES
  core_replace("angels-rocket", "war", "exploration")
  -- EXPLORATION
  OV.set_science_pack("angels-heavy-tank", "datacore-exploration-1", 2)
  -- CAB ADDONS
  if mods["angelsaddons-cab"] --[[angelsmods.addons.cab]] then
    OV.set_science_pack("angels-cab", "datacore-exploration-1", 2)
  end
  -- DECORATION ADDONS
  if mods["angelsaddons-nilaus"] --[[angelsmods.addons.decorations]] then
    OV.set_science_pack("nilaus-truck", "datacore-exploration-1", 2)
  end

  -------------------------------------------------------------------------------
  -- ENHANCEMENT CORES ----------------------------------------------------------
  -------------------------------------------------------------------------------
  -- BASE GAME
  core_replace("effect-transmission", "processing", "enhance")
  OV.set_science_pack("toolbelt", "datacore-enhance-1", 2)
  OV.set_science_pack("optics", "datacore-enhance-1", 2)
  core_replace("rocket-fuel", "war", "enhance")
  core_replace("artillery-shell-speed-1", "war", "enhance")
  core_replace("follower-robot-count-7", "war", "enhance")
  -- PETROCHEM
  core_replace("angels-rocket-fuel", "war", "enhance")
  -- INDUSTRIES
  --OV.set_science_pack("angels-components-construction-1", "datacore-enhance-1", 2)
  --OV.set_science_pack("angels-components-construction-2", "datacore-enhance-1", 2)
  --OV.set_science_pack("angels-components-construction-3", "datacore-enhance-1", 2)
  --OV.set_science_pack("angels-components-construction-4", "datacore-enhance-1", 2)
  --OV.set_science_pack("angels-components-construction-5", "datacore-enhance-1", 2)
  core_replace("angels-rocket-hull", "war", "enhance")

  -------------------------------------------------------------------------------
  -- ENERGY CORES ---------------------------------------------------------------
  -------------------------------------------------------------------------------
  -- BASE GAME
  core_replace("energy-weapons-damage-7", "war", "energy")
  core_replace("uranium-processing", "processing", "energy")
  core_replace("kovarex-enrichment-process", "processing", "energy")
  core_replace("nuclear-fuel-reprocessing", "processing", "energy")
  -- PETROCHEM
  core_replace("nuclear-fuel", "processing", "energy")
  -- INDUSTRIES
  OV.set_science_pack("angels-components-batteries-1", "datacore-energy-1", 2)
  OV.set_science_pack("angels-components-batteries-2", "datacore-energy-1", 2)
  OV.set_science_pack("angels-components-batteries-3", "datacore-energy-1", 2)
  OV.set_science_pack("angels-components-batteries-4", "datacore-energy-1", 2)
  OV.set_science_pack("angels-components-batteries-5", "datacore-energy-1", 2)
  core_replace("angels-rocket-fusion-reactor", "war", "energy")

  -------------------------------------------------------------------------------
  -- LOGISTIC CORES -------------------------------------------------------------
  -------------------------------------------------------------------------------
  -- PETROCHEM
  OV.set_science_pack("angels-fluid-control", "datacore-logistic-1", 2)
  -- INDUSTRIES
  --core_replace("angels-components-cabling-1", "energy", "logistic")
  core_replace("angels-components-cabling-2", "energy", "logistic")
  core_replace("angels-components-cabling-3", "energy", "logistic")
  core_replace("angels-components-cabling-4", "energy", "logistic")
  core_replace("angels-components-cabling-5", "energy", "logistic")
  OV.set_science_pack("angels-crawler", "datacore-logistic-1", 2)
  OV.set_science_pack("angels-yellow-loader", "datacore-logistic-1", 2)
  OV.set_science_pack("angels-red-loader", "datacore-logistic-1", 2)
  OV.set_science_pack("angels-blue-loader", "datacore-logistic-1", 2)
  core_replace("angels-rocket-ion-thruster", "war", "logistic")
  -- PRESSURE TANKS ADDONS
  if mods["angelsaddons-pressuretanks"] --[[angelsmods.addons.pressuretanks]] then
    OV.set_science_pack("pressure-tanks", "datacore-logistic-1", 2)
    OV.add_prereq("pressure-tanks", "tech-specialised-labs-basic-logistic-2")
  end
  --ORE SILO ADDONS
  if mods["angelsaddons-oresilos"] --[[angelsmods.addons.oresilos]] then
    core_replace("ore-silos", "processing", "logistic")
  end

  -------------------------------------------------------------------------------
  -- WARFARE CORES --------------------------------------------------------------
  -------------------------------------------------------------------------------
  -- BASE GAME
  for rec_4tech, _ in pairs(data.raw.technology) do --fix follower robot count techs
    if string.find(rec_4tech, "follower") ~= nil and string.find(rec_4tech, "robot") ~= nil then
      core_replace(rec_4tech, "logistic", "war")
    end
  end
  --undo the change for the infinite tech (would normally be in with enhancement)
  core_replace("follower-robot-count-7", "war", "enhance")
  if mods["angelsexploration"] then
    core_replace("angels-bio-gun", "processing", "war")
    core_replace("angels-refined-biological-1", "processing", "war")
    core_replace("angels-refined-biological-2", "processing", "war")
    core_replace("angels-refined-biological-3", "processing", "war")
    core_replace("angels-refined-biological-4", "processing", "war")
    core_replace("angels-refined-biological-5", "processing", "war")
    core_replace("angels-refined-biological-6", "processing", "war")
    core_replace("angels-refined-biological-7", "processing", "war")
  end

  -------------------------------------------------------------------------------
  -- PRODUCTION CORES -----------------------------------------------------------
  -------------------------------------------------------------------------------
  -- BASE GAME
  OV.set_science_pack("concrete", "datacore-processing-1", 2)
  OV.set_science_pack("circuit-network", "datacore-processing-1", 2)
  OV.set_science_pack("engine", "datacore-processing-1", 2)
  OV.set_science_pack("electric-engine", "datacore-processing-1", 2)
  OV.set_science_pack("lubricant", "datacore-processing-1", 2)
  OV.set_science_pack("low-density-structure", "datacore-processing-1", 2)
  -- REFINING
  OV.set_science_pack("geode-crystallization-1", "datacore-processing-1", 2)
  OV.set_science_pack("geode-crystallization-2", "datacore-processing-1", 2)
  OV.set_science_pack("thermal-water-extraction", "datacore-processing-1", 2)
  -- PETROCHEM
  OV.set_science_pack("angels-coal-cracking", "datacore-processing-1", 2)
  OV.set_science_pack("oil-gas-extraction", "datacore-processing-1", 2)
  OV.set_science_pack("angels-flare-stack", "datacore-processing-1", 2)
  OV.set_science_pack("gas-synthesis", "datacore-processing-1", 2)
  OV.set_science_pack("resin-1", "datacore-processing-1", 2)
  OV.set_science_pack("resin-2", "datacore-processing-1", 2)
  OV.set_science_pack("resin-3", "datacore-processing-1", 2)
  OV.set_science_pack("rubber", "datacore-processing-1", 2)
  core_replace("rocket-booster-1", "war", "processing")
  core_replace("rocket-booster-2", "war", "processing")
  OV.execute() ------------------------------------------------------------------

  -- now upgrade the cores to tier 2 and let them depend on the correct technology
  core_tier_upgrade()
  OV.execute()
  
  -- GLOBAL UPDATE TECHNOLOGY RESEARCH AMOUNT AND TIMES
  tech_unlock_reset()
  OV.execute()
end
